﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:gml="http://www.opengis.net/gml"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl gml"
  >

  <xsl:output method="html" indent="yes"/>
  <xsl:template match="/">
    <html>
      <head>
        <title></title>
        <style type="text/css">
          body {font-family: Arial, Helvetica, sans-serif;}
          table{border-collapse: collapse;
          font-size: 10pt;}
          td{padding: 2px;}
          .left {font-weight: bold;}
          .right{border-left: 2px solid #FFFFFF;}
          tr.even {
          background-color: #FCF6CF;
          }
          tr.odd {
          background-color: #FEFEF2;
          }
        </style>
      </head>
      <body>
        <table>
          <xsl:for-each select="./descendant::*">
            <tr>
              <xsl:if test="(position() mod 2 = 1)">
                <xsl:attribute name="class">even</xsl:attribute>
              </xsl:if>
              <xsl:if test="(position() mod 2 = 0)">
                <xsl:attribute name="class">odd</xsl:attribute>
              </xsl:if>
              <td class="left">
                <xsl:value-of select="local-name()"/>
              </td>
              <td class="right">
                <xsl:choose>
                  <xsl:when test="starts-with(text(),'http')">
                    <a target="_blank">
                      <xsl:attribute name="href">
                        <xsl:value-of select="text()"/>
                      </xsl:attribute>
                      <xsl:value-of select="text()"/>
                    </a>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="text()"/>
                  </xsl:otherwise>
                </xsl:choose>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>